<?php

class EWRporta_Model_Pages extends XenForo_Model
{
	public function getPageBySlug($pageSlug)
	{
		if (!$page = $this->_getDb()->fetchRow("
			SELECT *
				FROM EWRporta_pages
			WHERE page_slug = ?
		", $pageSlug))
		{
			return false;
		}

		return $page;
	}

	public function getPageByID($pageID)
	{
		$page = $this->_getDb()->fetchRow("
			SELECT *
				FROM EWRporta_pages
			WHERE page_id = ?
		", $pageID);

		return $page;
	}

	public function renderPage($page)
	{
		if ($page['page_type'] == 'phpfile')
		{
			$page['page_content'] = explode("\n", $page['page_content']);

			if (file_exists($page['page_content'][0]))
			{
				require_once($page['page_content'][0]);
			}
			else
			{
				$page['HTML'] = 'Could not find PHP file: '.$page['page_content'][0];
			}
		}
		else
		{
			$cache = $this->getModelFromCache('EWRporta_Model_Cache')->getCache($page);

			if ($cache['cache_date'] > $page['page_date'])
			{
				$page['HTML'] = $cache['cache_content'];
				$page['cache'] = $cache['cache_date'];
			}
			else
			{
				if ($page['page_type'] == 'bbcode')
				{
					$bbCodeParser = new XenForo_BbCode_Parser(XenForo_BbCode_Formatter_Base::create());
					$page['HTML'] = XenForo_Helper_String::autoLinkBbCode($page['page_content']);
					$page['HTML'] = $bbCodeParser->render($page['HTML']);
				}
				else
				{
					$page['HTML'] = $page['page_content'];
				}

				$page = $this->getModelFromCache('EWRporta_Model_Parser')->parseContents($page);
				$page = $this->getModelFromCache('EWRporta_Model_Parser')->parseTemplates($page);
				$page = $this->getModelFromCache('EWRporta_Model_Parser')->parseAutolinks($page);

				$dw = XenForo_DataWriter::create('EWRporta_DataWriter_Cache');
				if ($cache)
				{
					$dw->setExistingData($cache);
				}
				$dw->set('page_id', $page['page_id']);
				$dw->set('cache_content', $page['HTML']);
				$dw->preSave();
				$dw->save();
			}
		}

		return $page;
	}

	public function updatePage($input)
	{
		$dw = XenForo_DataWriter::create('EWRporta_DataWriter_Pages');

		if ($page = $this->getPageById($input['page_id']))
		{
			$dw->setExistingData($input);
		}

		$dw->set('page_name', $input['page_name']);
		$dw->set('page_slug', $input['page_slug']);
		$dw->set('page_type', $input['page_type']);
		$dw->set('page_content', $input['page_content']);
		$dw->set('page_parent', $input['page_parent']);
		$dw->preSave();
		$dw->save();

		$page = $this->_getDb()->fetchRow("SELECT * FROM EWRporta_pages WHERE page_slug = ?", $input['page_slug']);

		$this->_getDb()->query("
			UPDATE EWRporta_history
			SET history_current = '0'
			WHERE page_id = ?
		", $page['page_id']);

		$dw2 = XenForo_DataWriter::create('EWRporta_DataWriter_History');
		$dw2->set('page_id', $page['page_id']);
		$dw2->set('history_date', $page['page_date']);
		$dw2->set('history_type', $page['page_type']);
		$dw2->set('history_content', $page['page_content']);
		$dw2->set('history_current', '1');
		$dw2->preSave();
		$dw2->save();

		return $page;
	}

	public function deletePage($input)
	{
		$dw = XenForo_DataWriter::create('EWRporta_DataWriter_Pages');
		$dw->setExistingData($input);
		$dw->delete();

		$this->_getDb()->query("
			UPDATE EWRporta_pages
			SET page_parent = ?
			WHERE page_parent = ?
		", array($input['page_parent'], $input['page_id']));

		$this->_getDb()->query("
			DELETE FROM EWRporta_cache
			WHERE page_id = ?
		", $input['page_id']);

		$this->_getDb()->query("
			DELETE FROM EWRporta_history
			WHERE page_id = ?
		", $input['page_id']);

		return true;
	}
}